IF NOT OBJECT_ID('P_EST_PROD_FABRIC_AGENDA_GRUPO_ALCADA') IS NULL
	BEGIN 
		DROP PROCEDURE P_EST_PROD_FABRIC_AGENDA_GRUPO_ALCADA
	END

GO
 
CREATE PROCEDURE P_EST_PROD_FABRIC_AGENDA_GRUPO_ALCADA(@CD_CTR INT)
AS
BEGIN

	----------------------------------------------------------------------------------------------------------
	--GRAVANDO A DATA DA PROXIMA AGENDA
	----------------------------------------------------------------------------------------------------------
	IF EXISTS(SELECT I.CD_CTR 		
				FROM EST_ALCADA_CP_PED_LIB I
					INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
						I.CD_CTR = ALCADA_AGD.CD_CTR			
					INNER JOIN EST_PROD_FABRIC_AGENDA_GRUPO AGD ON 
						AGD.CD_CTR_GRUPO = ALCADA_AGD.CD_CTR_GRUPO
				WHERE I.CD_CTR = @CD_CTR) 
		BEGIN 
			UPDATE AGD SET 
				DT_AGENDAMENTO = ALCADA_AGD.DT_PROX_AGENDA_DEFAULT,
				DT_CAD = ALCADA.DT_CAD,
				CD_USU = ALCADA.CD_USU  		
			FROM EST_ALCADA_CP_PED_LIB I
				INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
					I.CD_CTR = ALCADA_AGD.CD_CTR
				INNER JOIN EST_ALCADA_CP_PED ALCADA ON 
					ALCADA_AGD.CD_EMP		= ALCADA.CD_EMP
					AND ALCADA_AGD.CD_CTR	= ALCADA.CD_CTR		
				INNER JOIN EST_PROD_FABRIC_AGENDA_GRUPO AGD ON 
					AGD.CD_CTR_GRUPO = ALCADA_AGD.CD_CTR_GRUPO
			WHERE I.CD_CTR = @CD_CTR			
		END
	ELSE
		BEGIN
			INSERT INTO EST_PROD_FABRIC_AGENDA_GRUPO (CD_CTR,
													  CD_CTR_GRUPO,
													  DT_AGENDAMENTO,
													  DT_CAD,
													  CD_USU)
			SELECT
				ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_FABRIC_AGENDA_GRUPO),0) + 1 AS CD_CTR,
				ALCADA_AGD.CD_CTR_GRUPO ,
				ALCADA_AGD.DT_PROX_AGENDA_DEFAULT,
				ALCADA.DT_CAD,
				ALCADA.CD_USU  		
			FROM EST_ALCADA_CP_PED_LIB I
				INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
					I.CD_CTR = ALCADA_AGD.CD_CTR
				INNER JOIN EST_ALCADA_CP_PED ALCADA ON 
					ALCADA_AGD.CD_EMP		= ALCADA.CD_EMP
					AND ALCADA_AGD.CD_CTR	= ALCADA.CD_CTR							
			WHERE I.CD_CTR = @CD_CTR
		END	
		
							
	----------------------------------------------------------------------------------------------------------
	--ALTERANDO O STATUS DA AGENDA DE PEDIDO EXECUTADA
	----------------------------------------------------------------------------------------------------------		
	UPDATE AGD SET 
		AGD.STATUS = 1
	FROM EST_ALCADA_CP_PED_LIB I
		INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
			I.CD_CTR = ALCADA_AGD.CD_CTR
		INNER JOIN EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO AGD ON 
			AGD.CD_EMP = ALCADA_AGD.CD_EMP
			AND AGD.CD_AGENDA = ALCADA_AGD.CD_AGENDA
	WHERE I.CD_CTR = @CD_CTR		

	 
	----------------------------------------------------------------------------------------------------------
	--ATUALZIANDO AS DATAS NO CADASTRO DA AGENDA
	----------------------------------------------------------------------------------------------------------
	UPDATE AGD SET 
		DT_AGENDAMENTO_DEFAULT = ALCADA_AGD.DT_PROX_AGENDA_DEFAULT,
		DT_ULT_ALT = ALCADA.DT_CAD,
		CD_USU = ALCADA.CD_USU  		
	FROM EST_ALCADA_CP_PED_LIB I
		INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
			I.CD_CTR = ALCADA_AGD.CD_CTR
		INNER JOIN EST_ALCADA_CP_PED ALCADA ON 
			ALCADA_AGD.CD_EMP		= ALCADA.CD_EMP
			AND ALCADA_AGD.CD_CTR	= ALCADA.CD_CTR		
		INNER JOIN EST_PROD_FABRIC_GRUPO AGD ON 
			AGD.CD_CTR_GRUPO = ALCADA_AGD.CD_CTR_GRUPO	
	WHERE I.CD_CTR = @CD_CTR		
			

	----------------------------------------------------------------------------------------------------------
	--CRIANDO A NOVA AGENDA DE PEDIDO
	----------------------------------------------------------------------------------------------------------
	INSERT INTO EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO (CD_EMP,CD_AGENDA,CD_CTR_GRUPO,DT_AGENDA,STATUS)
		SELECT 
			TOP 1 
			ALCADA_AGD.CD_EMP,
			ISNULL((SELECT MAX(CD_AGENDA) FROM EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO),0) + 1 AS CD_AGENDA,
			ALCADA_AGD.CD_CTR_GRUPO,
			ALCADA_AGD.DT_PROX_AGENDA,
			0 AS STATUS  
		FROM EST_ALCADA_CP_PED_LIB I
			INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO ALCADA_AGD ON 
				I.CD_CTR = ALCADA_AGD.CD_CTR
		WHERE I.CD_CTR = @CD_CTR

	----------------------------------------------------------------------------------------------------------
	--LIBERANDO OS PEDIDOS ELETRONICOS
	----------------------------------------------------------------------------------------------------------
	UPDATE E SET 
		FLAG_FECHAR = 0,
		STS_PED = 0
	FROM EST_ALCADA_CP_PED I
		INNER JOIN EST_ALCADA_CP_PED_EST_PED_ELTR_GRP_PED A_GRP ON 
			I.CD_CTR = A_GRP.CD_CTR 			
		INNER JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR GRP ON 
			A_GRP.CD_EMP = GRP.CD_EMP
			AND A_GRP.CD_GRP_PED = GRP.CD_GRP_PED
		INNER JOIN EST_PED_ELTR E ON 
			E.CD_EMP = GRP.CD_EMP
			AND E.CD_PED_SOL = GRP.CD_PED_SOL
	WHERE 
		I.CD_CTR = @CD_CTR	
		
END	